//vr360

#version 420
#pragma debug(on)
#pragma optimize(off)

layout (binding=0, set=1) uniform sampler2D s_tex_y;
layout (binding=1, set=1) uniform sampler2D s_tex_u;
layout (binding=2, set=1) uniform sampler2D s_tex_v;
// Binding 3 is for alpha texture in vr360Alpha shader
layout (binding=4, set=1) uniform udata {
	mat4 ModelViewMatrix;
	float fader;
	bool hasAlphaChannel; // Keep it since vr360Alpha shader uses the same udata block
};

#include <convertToRGB.glsl>

layout (location=0) in vec2 TexCoord;

layout (location=0)out vec4 FragColor;

void main(void)
{
    vec3 tex_color = convertToRGB(s_tex_y, s_tex_u, s_tex_v, TexCoord);
    FragColor = vec4(tex_color, fader);
}
